#!/bin/sh
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

#########################################################
# Script to start/stop syslog-ng test server.
# Configuration needs to pass by environment variables
#   - SYSLOGNG_CLIENT_IP
#   - SYSLOGNG_CLIENT_PORT
#   - SYSLOGNG_CLIENT_TRANS_MODE
#   - SYSLOGNG_CLIENT_FORMAT
#   - SYSLOGNG_CLIENT_SSL
#   - SYSLOGNG_CLIENT_IPTYPE
#########################################################

FILE_SYSLOGNG_TEST_PID=/var/run/syslogng_test.pid
PATH_SYSLOGNG_TEMPLATE_FOLDER=/usr/syno/syslog/etc/template/client/

PATH_SYSLOGNG_CONF=/usr/syno/etc/synosyslog
FILE_SYNOSYSLOG_TEST_CONF=${PATH_SYSLOGNG_CONF}/testconn.conf

TestConfDataClear(){
    rm -rf ${FILE_SYNOSYSLOG_TEST_CONF} > /dev/null 2>&1
}
TestConfFolderCreate(){
    echo "not implemented"
}

TestVerProcess(){
    touch ${FILE_SYNOSYSLOG_TEST_CONF}
    echo "@version:3.5.5" >> ${FILE_SYNOSYSLOG_TEST_CONF} #Hint of syslog-ng config version
    echo "options { keep_hostname(yes); };" >> ${FILE_SYNOSYSLOG_TEST_CONF}
}
TestSourceProcess(){
    if [ "ietf" == "${SYSLOGNG_CLIENT_FORMAT}" ]; then
        echo 'source s_syno_syslog { unix-stream("/var/run/test" flags(syslog-protocol)); };' \
        >> ${FILE_SYNOSYSLOG_TEST_CONF}
    else
        echo 'source s_syno_syslog { unix-stream("/var/run/test"); };' \
        >> ${FILE_SYNOSYSLOG_TEST_CONF}
    fi
}

TestDestProcess(){
    local DSTTYPE="network"
    local TRANSPORT="udp"
    local TLS_RULE=""

    if [ "ietf" == ${SYSLOGNG_CLIENT_FORMAT} ]; then
        DSTTYPE="syslog"
    fi

    if [ "tcp" == ${SYSLOGNG_CLIENT_TRANS_MODE} ]; then
        TRANSPORT="tcp"
        if [ "1" == ${SYSLOGNG_CLIENT_SSL} ]; then
            TRANSPORT="tls"
            TLS_RULE="tls(ca_dir(\"${SYSLOGNG_CLIENT_CA_FILE_PATH}\"))"
        fi
    fi

    cat ${PATH_SYSLOGNG_TEMPLATE_FOLDER}/dest.template |
    sed -e "s/__SYNO_DSTTYPE__/${DSTTYPE}/" \
        -e "s/__SYNO_IP__/\"${SYSLOGNG_CLIENT_IP}\"/" \
        -e "s/__SYNO_PORT__/${SYSLOGNG_CLIENT_PORT}/" \
        -e "s/__SYNO_TRANSPORT__/${TRANSPORT}/" \
        -e "s/__SYNO_IPV__/${SYSLOGNG_CLIENT_IPTYPE}/" \
        -e "s=__SYNO_CA_SETTING__=${TLS_RULE}=" \
        >> ${FILE_SYNOSYSLOG_TEST_CONF}
}
TestLogProcess(){
    echo "log { source(s_syno_syslog); destination(d_syno_internet); flags(flow_control); };" \
    >> ${FILE_SYNOSYSLOG_TEST_CONF}
}

CheckIfDaemonAlive(){
    PROCESS_ALIVE=0
    if [ -f "$1" ]; then
        PROCESS_PID=`cat $1`
        kill -0 ${PROCESS_PID}
        if [ "0" = "$?" ]; then
            PROCESS_ALIVE=1
        fi
    fi
}

TestSyslogngStart(){
    /usr/bin/syslog-ng --pidfile=${FILE_SYSLOGNG_TEST_PID} --cfgfile=${FILE_SYNOSYSLOG_TEST_CONF} --persist-file="/tmp/syslog-ng-test.persist" --control="/tmp/syslog-ng-test.ctl"
}
TestSyslogngStop(){
    CheckIfDaemonAlive ${FILE_SYSLOGNG_TEST_PID}
    if [ "1" == "$PROCESS_ALIVE" ]; then
        kill ${PROCESS_PID}
        sleep 1;
    fi

    TestConfDataClear;
}

case $1 in
    start)
        echo "Syslog-ng test server start..."
        TestConfDataClear;
        #TestConfFolderCreate;

        TestVerProcess;    
        TestSourceProcess;
        TestDestProcess;
        TestLogProcess;

        TestSyslogngStart;
    ;;
    stop)
        echo "Syslog-ng test server stop..."
        TestSyslogngStop;
    ;;
    *)
        echo "Usage: $0 start|stop"
    ;;
esac
